/*
 * Decompiled with CFR 0.152.
 */
package xmlstreamparser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import xmlstreamparser.HttpNode;

public class Node {
    public static final char[] ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    public static int[] toInt = new int[128];
    public Node parent;
    public String name;
    public Hashtable attributes;
    public String text;
    public Vector children;

    public static byte[] decode(String s) {
        int delta = s.endsWith("==") ? 2 : (s.endsWith("=") ? 1 : 0);
        byte[] buffer = new byte[s.length() * 3 / 4 - delta];
        int mask = 255;
        int index = 0;
        for (int i = 0; i < s.length(); i += 4) {
            int c0 = toInt[s.charAt(i)];
            int c1 = toInt[s.charAt(i + 1)];
            buffer[index++] = (byte)((c0 << 2 | c1 >> 4) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c2 = toInt[s.charAt(i + 2)];
            buffer[index++] = (byte)((c1 << 4 | c2 >> 2) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c3 = toInt[s.charAt(i + 3)];
            buffer[index++] = (byte)((c2 << 6 | c3) & mask);
        }
        return buffer;
    }

    public static String encode(byte[] buf) {
        int size = buf.length;
        char[] ar = new char[(size + 2) / 3 * 4];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = buf[i++];
            byte b1 = i < size ? buf[i++] : (byte)0;
            byte b2 = i < size ? buf[i++] : (byte)0;
            int mask = 63;
            ar[a++] = ALPHABET[b0 >> 2 & mask];
            ar[a++] = ALPHABET[(b0 << 4 | (b1 & 0xFF) >> 4) & mask];
            ar[a++] = ALPHABET[(b1 << 2 | (b2 & 0xFF) >> 6) & mask];
            ar[a++] = ALPHABET[b2 & mask];
        }
        switch (size % 3) {
            case 1: {
                ar[--a] = 61;
            }
            case 2: {
                ar[--a] = 61;
            }
        }
        return new String(ar);
    }

    public Node(Node _parent) {
        this.parent = _parent;
        this.name = "";
        this.attributes = new Hashtable(4);
        this.text = "";
        this.children = new Vector(3, 1);
        if (this.parent != null) {
            this.parent.children.addElement(this);
        }
    }

    public Node(HttpNode _node) {
        this.name = _node.name;
        this.text = _node.value;
        this.attributes = _node.attributes;
        this.children = new Vector(3, 1);
        this.setChildren(_node.childs);
    }

    private void setChildren(Vector http) {
        if (http != null) {
            for (int i = 0; i < http.size(); ++i) {
                this.children.addElement(new Node((HttpNode)http.elementAt(i)));
            }
        }
    }

    public String getValue(String _attributeName) {
        return (String)this.attributes.get(_attributeName);
    }

    public Node getChild(String _nodeName) {
        boolean found = false;
        Node tmp = null;
        for (int i = 0; i < this.children.size() && !found; ++i) {
            tmp = (Node)this.children.elementAt(i);
            if (!tmp.name.equals(_nodeName)) continue;
            found = true;
        }
        if (!found) {
            tmp = null;
        }
        return tmp;
    }

    public Node getChild(String _nodeName, String _attrName, String _attrVal) {
        boolean found = false;
        Node tmp = null;
        for (int i = 0; i < this.children.size() && !found; ++i) {
            tmp = (Node)this.children.elementAt(i);
            if (!tmp.name.equals(_nodeName) || !tmp.getValue(_attrName).equals(_attrVal)) continue;
            found = true;
        }
        if (!found) {
            tmp = null;
        }
        return tmp;
    }

    public Vector getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append('<');
        buffer.append(this.name);
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            buffer.append(' ');
            buffer.append(key);
            String value = (String)this.attributes.get(key);
            if (value == "") continue;
            buffer.append("='");
            buffer.append(value);
            buffer.append("'");
        }
        buffer.append('>');
        buffer.append(this.text);
        for (int i = 0; i < this.children.size(); ++i) {
            Node child = (Node)this.children.elementAt(i);
            buffer.append(child.toString());
        }
        buffer.append("</");
        buffer.append(this.name);
        buffer.append('>');
        return buffer.toString();
    }

    static {
        for (int i = 0; i < ALPHABET.length; ++i) {
            Node.toInt[Node.ALPHABET[i]] = i;
        }
    }
}

